@echo off

cls

set SERVER=.\TIMESAFE

REM -----------------------------------------------------------------------
REM ----Datenbank
set DB=TimeSafeLeistungserfassung

REM -----------------------------------------------------------------------
REM ---- BACKUPFILE muss dem im Server Root Directory angegebenen Pfad entsprechen.
REM
set BACKUPFILE=C:\Program Files\Microsoft SQL Server\MSSQL11.TIMESAFE\MSSQL\Backup\%DB%.bak


echo Der Dienst "MSSQLServer" wird gestoppt und gestartet, damit
echo sichergestellt ist, dass keine Verbindung zur Datenbank mehr
echo existiert.
echo.
echo Wenn Sie das nicht moechten, druecken Sie jetzt CTRL+C
echo und bestaetigen Sie mit J.
echo.

pause

REM -----------------------------------------------------------------------
REM ---- Die Batch Datei muss mit Administratorenrechten gestartet werden!
rem net stop MSSQLServer
rem net start MSSQLServer

REM -----------------------------------------------------------------------
REM ----
echo Bitte bearbeiten Sie das Skript, um es lauffaehig zu machen.
echo Die Datenbank wurde nicht wiederhergestellt.

rem Die folgenden Zeilen wurden mit "rem" auskommentiert, um eine
rem versehentliche Wiederherstellung der Datenbank zu vermeiden.
rem Bitte entfernen Sie "rem" am Zeilenanfang, wenn Sie dieses
rem Skript benutzen wollen.

REM sqlcmd -S "%SERVER%" -E -I -Q "RESTORE DATABASE [%DB%] FROM DISK = '%BACKUPFILE%'"
REM sqlcmd -S "%SERVER%" -E -I -Q "USE [%DB%]; exec sp_change_users_login 'Auto_Fix', 'TimeSafe_usr';"

REM PAUSE

